<?php
if (!defined('_GNUBOARD_')) exit; //개별 페이지 접근 불가

// 옵션
$wos = apms_options($options, $m_options);
$list = apms_board_rows($wos);
$list_cnt = count($list);
if(!$list_cnt) {
	echo '<p class="text-muted text-center">글이 없습니다.</p>'.PHP_EOL;	
	return;
}

if(!$wos['icon']) $wos['icon'] = 'caret-right';
if(!$wos['new']) $wos['new'] = 'red';

?>

<ul class="widget-list">
	<?php for ($i=0; $i < $list_cnt; $i++) { ?>
		<li>
			<a href="<?php echo $list[$i]['href'];?>">
				<?php if($list[$i]['comment']) { ?>
					<span class="pull-right cnt"><?php echo number_format($list[$i]['comment']);?></span>
				<?php } ?>
				<?php if($wos['rank']) { ?>
					<span class="en widget-rank-icon widget-rank-<?php echo $wos['rank'];?>"><?php echo $i+1;?></span>
				<?php } else { ?>
					<span class="icon">
						<i class="fa fa-<?php echo $wos['icon'];?><?php echo ($list[$i]['new']) ? ' '.$wos['new'] : '';?>"></i>
					</span>
				<?php } ?>
				<?php echo $list[$i]['subject'];?>
			</a> 
		</li>
	<?php } ?>
</ul>
